library(npreg)
BAMtoGR <- function(bam,bai){
  library(Rsamtools)
  
  # Create parameters for scanBam
  what <- c("rname", "pos", "strand", "isize")
  param <- ScanBamParam(what = what)
  
  reads <- scanBam(file = bam, 
                   index = bai, 
                   param = param)
  # Convert reads to GR
  return (GRanges(seqnames = reads[[1]][['rname']],
                  ranges = IRanges(start = reads[[1]][['pos']], width = reads[[1]][['isize']]),
                  strand = reads[[1]][['strand']]))
}

#load files 
nuc_master = read.csv('~/data/nuc_master.csv')
nuc_master_sub = subset(nuc_master,cac_c40 > quantile(nuc_master$cac_c40,0.25) & wt_c40 > quantile(nuc_master$wt_c40,0.25) )

nuc_chrIV = subset(nuc_master_sub,chr=='chrIV')
cac_pulse_small_occu = data.frame(chr='chrIV',peak = nuc_chrIV$peak,left = NA,right = NA)
SacCer = read.fasta('~/data/feature_file/SacCer3.fa')

#get small fragment occupancy surrounding nuc on chrIV
file_name.bam ="~/cac/final/bam_bai/sampled/cac_pulse_sampled.bam"
file_name.bam.bai = "~/cac/final/bam_bai/sampled/cac_pulse_sampled.bam.bai"
gr = BAMtoGR(file_name.bam,file_name.bam.bai)

mid.df_all=data.frame(chr=seqnames(gr),
                      mid=start(gr)+(width(gr)/2),
                      length=width(gr))

mid.df_all = subset(mid.df_all, length < 80 & chr=='chrIV')
cac_pulse_small.mtx = matrix(0,nrow = nrow(nuc_chrIV),ncol=401)

for (i in 1:nrow(nuc_chrIV)){
  peak = floor(nuc_chrIV$peak[i])
  mid_nuc_sub=subset(mid.df_all, mid>=(peak-200) & mid<=(peak+200)) #occupancy for the 400 bp window for plotting
  o = hist(mid_nuc_sub$mid,seq(peak-200,peak+200+1,1),plot = F,right = F)$counts 
  cac_pulse_small.mtx[i,] = o #occupancy for the 400 bp plotting window
  
  cac_pulse_small_occu$left[i] = sum(o[131:201]) 
  cac_pulse_small_occu$right[i] = sum(o[201:271])
  if((i %% 500) == 0 ){
    cat(paste("nucleosome #",i,"\n"))
  }
}

cac_pulse_small_occu$left_to_rigth_ratio = cac_pulse_small_occu$left / cac_pulse_small_occu$right

cac_pulse_small_occu$left_CG = 0
cac_pulse_small_occu$right_CG = 0
cac_pulse_small_occu$left_AT = 0
cac_pulse_small_occu$right_AT = 0

for (i in 1:nrow(nuc_chrIV)) {
  if((i %% 500) == 0 ){
    cat(paste("Finishing nucleosome #",i,"\n"))
  }
  
  p = floor(nuc_chrIV$peak[i])
  left_seq = SacCer[['chrIV']][(p-70):p]
  right_seq = SacCer[['chrIV']][p:(p+70)]
  
  cac_pulse_small_occu$left_CG[i] = length(which(left_seq=='c' |left_seq=='g' ))
  cac_pulse_small_occu$right_CG[i] = length(which(right_seq=='c' |right_seq=='g' ))
  cac_pulse_small_occu$left_AT[i] = length(which(left_seq=='a' |left_seq=='t' ))
  cac_pulse_small_occu$right_AT[i] = length(which(right_seq=='a' |right_seq=='t' ))
  
}

mtx_ordered = cac_pulse_small.mtx[order(cac_pulse_small_occu$left_to_rigth_ratio,decreasing = TRUE),]

#plotting
scr.m = matrix(c(0.1, 0.45, 0.15, 0.9,
                 0.45, 0.9, 0.15, 0.9,
                 0.2, 0.45, 0.02, 0.15
                 
),
ncol = 4, byrow = T
)


#plotting
#pulse
file.name <- "/data/figure/figure4/figure4_AT_preference.png"
png(file = file.name, width = 6, height = 8, units = "in", res = 300, bg = "white", type = "cairo-png" )
par(cex=1.5)

close.screen(all.screens = T)

split.screen(scr.m)

par(oma = c(0, 3, 0, 0)) # make room (i.e. the 4's) for the overall x and y axis titles
screen(1)
par(mar = c(4,0.5,0.5,0.5), cex=0.7) 
a = mtx_ordered
dens_dot_plot(a[nrow(a):1,],  z_min =0, z_max =5, plot_title='',y_axt = "n",lowCol = 'white', highCol = "blue", numColors = 50) #adjust z range for each experiment
abline(v=0,col='grey30',lty=2,lwd=0.8)
axis(side=1,labels=F, tick=F,at=c(-200,-100,0,100,200)) #x-axis
#mtext(side = 1,text='Distance from nucleosome dyad (bp)',line=2,cex=0.8)
mtext(side = 2,text='Nucleosomes on ChrIV',line=1)

screen(2)
par(mar = c(4,0.5,0.5,0.5), cex=0.7) 
x = log2((cac_pulse_small_occu$right_AT /cac_pulse_small_occu$left_AT))[order(cac_pulse_small_occu$left_to_rigth_ratio,decreasing = TRUE)]
y = rev(seq(1,nrow(cac_pulse_small_occu),1))
mod.ss <- ss(y, x)
plot(x,y,pch=16,ylab='',xlab='',yaxs='i',yaxt='n',col=alpha('grey80',0.5),cex=0.6,xlim=c(-0.6,0.6))
abline(v = 0,col='black',lty=2)
lines(mod.ss$y,mod.ss$x,col='red',lwd=3)


#mtext(side = 1,text='AT bias',line=2,cex=0.8)

screen(3)
eff_color2 <- matrix(c(0,0.5,1,1.5,2,2.5,3), nrow=1, ncol=7)
par(mar = c(2,0.5,1,0.3))
dens_dot_plot(eff_color2, z_min = 0, z_max = 5, plot_title="",x_axt='n',y_axt = "n",lowCol = 'white', highCol = "blue",numColors = 50)
mtext(at=c(-3,0,3), text=c(0,1.5,5), side=1,cex=1)

close.screen(all.screens = T)

dev.off()
















